//********************************************************************;
//*                                                                  *;
//*  Intel(R) Confidential                                           *;
//*                                                                  *;
//*  TXTINFO64   Tool                                                *;
//*                                                                  *;
//*  Copyright (c) 2009 Intel Corp.                                  *;
//*                                                                  *;
//*  This code has been developed by Intel Corporation.              *;
//*  Licensee has Intel's permission to incorporate this source code *;
//*  into their product, royalty free.  This source code may NOT be  *;
//*  redistributed to anyone without Intel's written permission.     *;
//*                                                                  *;
//*  Intel specifically disclaims all warranties, express or         *;
//*  implied, and all liability, including consequential and other   *;
//*  indirect damages, for the use of this code, including liability *;
//*  for infringement of any proprietary rights, and including the   *;
//*  warranties of merchantability and fitness for a particular      *;
//*  purpose.  Intel does not assume any responsibility for any      *;
//*  errors which may appear in this code nor any responsibility to  *;
//*  update it.                                                      *;
//*                                                                  *;
//********************************************************************;

#include "WaitAndStatusCheck.h"

/***************************************TPM STATUS CHECK CODES****************************/
#define TPM_STATUS_SUCCESS	0
#define TPM_STATUS_FAILURE	1

/*
	Return: TPM_STATUS_FAILURE => timeout
			TPM_STATUS_SUCCESS => successfull
*/
UINT8 WaitAndStatusCheck(UINT32 u32WaitMS, STATUS_CHECK_PROC_PTR pStatusChkProc, void *pBuffer)
{
	UINT32 u32StatusChkCntr = u32WaitMS;
	UINT8 u8Status = TPM_STATUS_FAILURE; //Status Check failure
	for(u32StatusChkCntr = u32WaitMS; u32StatusChkCntr > 0; u32StatusChkCntr--){
		u8Status = pStatusChkProc(pBuffer);
		if(TPM_STATUS_SUCCESS == u8Status){
			//Status Check Success
			break;
		}
		ASMDelay1MS();
	}
	return u8Status;
}